function zadatak9(eps)
    if (nargin < 1)
        eps = 0.0001;
    end
    f = inline('exp(x-2)-x-0.5');
    a1 = -1; b1 = 3;
    a2 = 0; b2 = 4;
    fp = inline('exp(x-2)-1');
    fpp = inline('exp(x-2)');
%    xi = -4:0.01:4;
%    plot(xi, f(xi));
    disp('NJUTNOVA METODA TANGENTE:');
    disp('                      Prva nula');
    NjutnovaMetodaTangenti(f, fp, fpp, a1, b1, eps, 1);
    disp('                      Druga nula');
    NjutnovaMetodaTangenti(f, fp, fpp, a2, b2, eps, 1);
    disp('KOMBINOVANA METODA:');
    disp('                      Prva nula');
    KombinovanaMetoda(f, fp, fpp, a1, b1, eps, 1);
    disp('                      Druga nula');
    KombinovanaMetoda(f, fp, fpp, a2, b2, eps, 1);
    epsi = 0.0000001:0.00004:0.001;
    n = length(epsi);
    for i = 1:n
        [x, n11(i)] = NjutnovaMetodaTangenti(f, fp, fpp, a1, b1, eps, 0);
        [x, n12(i)] = NjutnovaMetodaTangenti(f, fp, fpp, a2, b2, eps, 0);
        [x, n21(i)] = KombinovanaMetoda(f, fp, fpp, a1, b1, eps, 0);
        [x, n22(i)] = KombinovanaMetoda(f, fp, fpp, a2, b2, eps, 0);
    end
    plot(epsi, n11, epsi, n12, epsi, n21, epsi, n22);
    title('Konvergencija koraka u zavisnosti od tacnosti');
    legend('NMT 1', 'NMT 2', 'KM  1', 'KM  2');

function [xn, n] = NjutnovaMetodaTangenti(f, fp, fpp, a, b, eps, c)
%    m1 = fp(fminbnd(inline(abs(sym(fp))), a, b));
%    M2 = fpp(fminbnd(inline(1/sym(fpp)), a, b));
    m1 = min(abs(fp(a)), abs(fp(b)));
    M2 = max(abs(fpp(a)), abs(fpp(b)));
    if (f(a)*fpp(a) > 0)
        xn = a;
    else
        xn = b;
    end
    if (c)
        disp('+---+---------------+---------------+---------------+');
        disp('| n |      Xn       |     f(Xn)     |     f''(Xn)    |');
        disp('+---+---------------+---------------+---------------+');
    end
    n = 0;
    while (1)
        if (c)
            disp(sprintf('|%3d|%15.10f|%15.10f|%15.10f|', n, xn, f(xn), fp(xn)));
        end
        xnp = xn;
        xn = xnp-f(xnp)/fp(xnp);
        n = n+1;
        if (abs(f(xn)) <= eps*m1)
            break;
        end
        if (abs(xn-xnp)<= sqrt(2*eps*m1/M2))
            break;
        end
    end
    if (c)
        disp(sprintf('|%3d|%15.10f|%15.10f|%15.10f|', n, xn, f(xn), fp(xn)));
        disp('+---+---------------+---------------+---------------+');
    end

function [xn, n] = KombinovanaMetoda(f, fp, fpp, a, b, eps, c)
%    m = fp(fminbnd(inline(abs(sym(fp))), a, b));
    m = min(abs(fp(a)), abs(fp(b)));
    if (f(a)*fpp(a) > 0)
        xpn = a;
        xn = b;
    else
        xpn = b;
        xn = a;
    end
    if (c)
        disp('+---+---------------+---------------+---+---------------+---------------+---------------+');
        disp('| n |      Xn       |     f(Xn)     | n |      Xn''      |     f(Xn'')    |    f''(Xn'')    |');
        disp('+---+---------------+---------------+---+---------------+---------------+---------------+');
    end
    n = 0;
    while (1)
        if (c)
            disp(sprintf('|%3d|%15.10f|%15.10f|%3d|%15.10f|%15.10f|%15.10f|', n, xn, f(xn), n, xpn, f(xpn), fp(xpn)));
        end
        xpnp = xpn;
        xnp = xn;
        xpn = xpnp - f(xpnp)/fp(xpnp);
        xn = xnp-(f(xnp)*(xnp-xpnp))/(f(xnp)-f(xpnp));
        n = n + 1;
        if (abs(f(xn)) <= m*eps)
            break;
        end
        if (abs(xn-xpn) < eps)
            break;
        end
    end
    if (c)
        disp(sprintf('|%3d|%15.10f|%15.10f|%3d|%15.10f|%15.10f|%15.10f|', n, xn, f(xn), n, xpn, f(xpn), fp(xpn)));
        disp('+---+---------------+---------------+---+---------------+---------------+---------------+');
    end
